package kom.itbeankit.nw.ethernet;

import java.awt.*;
import kom.itbeankit.common.message.MessageEvent;

public class HostDialog extends Dialog implements EthernetInterface{

	public HostDialog(Frame parent, boolean modal)
	{
		super(parent, modal);

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.

		//{{INIT_CONTROLS
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		setLayout(gridBagLayout);
		setVisible(false);
		setSize(200,160);
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setBackground(new Color(12632256));
		applyButton = new java.awt.Button();
		applyButton.setLabel(" Apply ");
		applyButton.setBounds(5,128,49,23);
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 3;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(2,5,2,0);
		((GridBagLayout)getLayout()).setConstraints(applyButton, gbc);
		add(applyButton);
		applyButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		doneButton = new java.awt.Button();
		doneButton.setLabel(" Done ");
		doneButton.setBounds(145,128,50,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 3;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(2,0,2,5);
		((GridBagLayout)getLayout()).setConstraints(doneButton, gbc);
		add(doneButton);
		doneButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		destinationLabel = new java.awt.Label("Destination");
		destinationLabel.setBounds(5,0,74,33);
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(2,5,2,0);
		((GridBagLayout)getLayout()).setConstraints(destinationLabel, gbc);
		add(destinationLabel);
		destinationChoice = new java.awt.Choice();
		destinationChoice.addItem("None");
		destinationChoice.addItem("Broadcast");
		destinationChoice.addItem("1");
		destinationChoice.addItem("2");
		destinationChoice.addItem("3");
		destinationChoice.addItem("4");
		destinationChoice.addItem("5");
		destinationChoice.addItem("6");
		destinationChoice.addItem("7");
		destinationChoice.addItem("8");
		try {
			destinationChoice.select(0);
		}
		catch (IllegalArgumentException e) { }
		destinationChoice.setBounds(114,9,77,21);
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(2,0,2,5);
		((GridBagLayout)getLayout()).setConstraints(destinationChoice, gbc);
		add(destinationChoice);
		destinationChoice.setCursor(new Cursor(Cursor.HAND_CURSOR));
		farmeSizeLabel = new java.awt.Label("Frame Size");
		farmeSizeLabel.setBounds(5,40,74,33);
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(2,5,2,0);
		((GridBagLayout)getLayout()).setConstraints(farmeSizeLabel, gbc);
		add(farmeSizeLabel);
		helpButton = new java.awt.Button();
		helpButton.setLabel("?");
		helpButton.setBounds(83,48,21,23);
		helpButton.setFont(new Font("Dialog", Font.BOLD, 12));
		helpButton.setForeground(new Color(255));
		helpButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(2,0,2,10);
		((GridBagLayout)getLayout()).setConstraints(helpButton, gbc);
		add(helpButton);
		frameSizeChoice = new java.awt.Choice();
		frameSizeChoice.addItem("Normal");
		frameSizeChoice.addItem("too short");
		frameSizeChoice.addItem("too long");
		try {
			frameSizeChoice.select(0);
		}
		catch (IllegalArgumentException e) { }
		frameSizeChoice.setBounds(114,49,81,21);
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 1;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(2,0,2,5);
		((GridBagLayout)getLayout()).setConstraints(frameSizeChoice, gbc);
		add(frameSizeChoice);
		frameSizeChoice.setCursor(new Cursor(Cursor.HAND_CURSOR));
		repeatLabel = new java.awt.Label("Auto Repeat");
		repeatLabel.setBounds(5,80,78,40);
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 2;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(2,5,2,0);
		((GridBagLayout)getLayout()).setConstraints(repeatLabel, gbc);
		add(repeatLabel);
		repeatChoice = new java.awt.Choice();
		repeatChoice.addItem("NO");
		repeatChoice.addItem("YES");
		try {
			repeatChoice.select(0);
		}
		catch (IllegalArgumentException e) { }
		repeatChoice.setBounds(114,89,81,21);
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 2;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(2,0,2,5);
		((GridBagLayout)getLayout()).setConstraints(repeatChoice, gbc);
		add(repeatChoice);
		repeatChoice.setCursor(new Cursor(Cursor.HAND_CURSOR));
		setTitle("Host No. ");
		setResizable(false);
		//}}

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		applyButton.addActionListener(lSymAction);
		doneButton.addActionListener(lSymAction);
		helpButton.addActionListener(lSymAction);
		//}}

	}

	public HostDialog(Frame parent, Host host)
	{
		this(parent, false);
		this.host = host;
		String hostID = new Integer(host.getID()).toString();
		setTitle(getTitle() + hostID);
		destinationChoice.remove(host.getID()+1);
		setDestinationHost(host.getDestinationHost());
		setFrameSize(host.getFrameSize());
		setAutoRepeat(host.isAutoRepeat());
	}

	public HostDialog(Frame parent, String title, boolean modal)
	{
		this(parent, modal);
		setTitle(title);
	}

	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
                Dimension d = getSize();

		super.addNotify();

		// Only do this once.
		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets().left, insets().top);
			components[i].setLocation(p);
		}

		// Used for addNotify check.
		fComponentsAdjusted = true;
	}

	public void setVisible(boolean b)
	{
	    if (b)
	    {
    		Rectangle bounds = getParent().bounds();
    		Rectangle abounds = bounds();

    		setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
    			 bounds.y + (bounds.height - abounds.height));
	    }

		super.setVisible(b);
	}

	//{{DECLARE_CONTROLS
	java.awt.Button applyButton;
	java.awt.Button doneButton;
	java.awt.Label destinationLabel;
	java.awt.Choice destinationChoice;
	java.awt.Label farmeSizeLabel;
	java.awt.Button helpButton;
	java.awt.Choice frameSizeChoice;
	java.awt.Label repeatLabel;
	java.awt.Choice repeatChoice;
	//}}
    Host host;
    
        // Used for addNotify check.
	boolean fComponentsAdjusted = false;

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == HostDialog.this)
				HostDialog_WindowClosing(event);
		}
	}

	void HostDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
                host.hostDialog = null;
                host = null;
                dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == applyButton)
				applyButton_Clicked(event);
			else if (object == doneButton)
				doneButton_Clicked(event);
			else if (object == helpButton)
				helpButton_ActionPerformed(event);
		}
	}

	void doneButton_Clicked(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Clicked from okButton Hide the Dialog
                applyButton_Clicked(event);
                host.hostDialog = null;
                host = null;
                dispose();
		//}}
	}

	void applyButton_Clicked(java.awt.event.ActionEvent event)
	{
		host.setFrameSize(getFrameSize());
		host.setAutoRepeat(isAutoRepeat());
		host.setDestinationHost(getDestinationHost());
	}
	
	public int getFrameSize(){
	     int frameSize=0;
	     switch(frameSizeChoice.getSelectedIndex()){
	        case 0:
	            frameSize=FRAME_SIZE_NORMAL;
	            break;
	        case 1:
	            frameSize=FRAME_SIZE_SHORT;
	            break;
	        case 2:
	            frameSize=FRAME_SIZE_LONG;
	            break;
	        default:
	     }
	     return frameSize;
	}
	
	public int getDestinationHost(){
	    String destination = destinationChoice.getSelectedItem();
	    int index = destinationChoice.getSelectedIndex();
	    switch(index){
	        case 0:
	            return  HOST_ADDRESS_NONE;
	        case 1:
	            return  HOST_ADDRESS_BROADCAST;
            default:
                return (new Integer(destination).intValue());
        }
	}
	
	public boolean isAutoRepeat(){
	    return(repeatChoice.getSelectedIndex()==1);
	}
	
	public void setFrameSize(int frameSize){
	     int index=0;
	     switch(frameSize){
	        case FRAME_SIZE_NORMAL:
	            break;
	        case FRAME_SIZE_SHORT:
	            index=1;
	            break;
	        case FRAME_SIZE_LONG:
	            index=2;
	            break;
	        default:
	     }
	     frameSizeChoice.select(index);
	}
	
	public void setDestinationHost(int DestinationHost){
	    switch(DestinationHost){
	        case HOST_ADDRESS_NONE:
	            destinationChoice.select(0);
	            break;
	        case HOST_ADDRESS_BROADCAST:
	            destinationChoice.select(1);
	            break;
	        default:
	            destinationChoice.select(new Integer(DestinationHost).toString());
	    }
	}
	
	public void setAutoRepeat(boolean autoRepeat){
	    int index = 0;
	    if(autoRepeat)
	        index = 1;
	    repeatChoice.select(index);    
	}

	void helpButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		host.fireMessageEvent(new MessageEvent(host, 
		                                        MessageEvent.DISPLAY_TYPE_DIALOG,
		                                        MessageEvent.MSG_TYPE_INFO,
		                                        HostTexts.HOST_DIALOG,
		                                        HostTexts.HELP_MSG));
	}
}
